<?php
/* Copyright (C) 2021 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    landingpage/class/actions_landingpage.class.php
 * \ingroup landingpage
 * \brief   Example hook overload.
 *
 * Put detailed description here.
 */

if (! defined('NOTOKENRENEWAL'))           define('NOTOKENRENEWAL','1');				// Do not roll the Anti CSRF token (used if MAIN_SECURITY_CSRF_WITH_TOKEN is on)

/**
 * Class ActionsLandingPage
 */
class ActionsLandingPage
{
    /**
     * @var DoliDB Database handler.
     */
    public $db;

    /**
     * @var string Error code (or message)
     */
    public $error = '';

    /**
     * @var string String displayed by executeHook() immediately after return
     */
    public $resprints;

    /**
     * Constructor
     *
     * @param DoliDB $db Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
    }

	/**
	 * Get the module header for information tab
	 *
	 * @param   array       $parameters         Array of parameter (we only use $parameters['module'] to check module header to display)
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	public function generateInformationTabHeader($parameters)
	{
		dol_include_once('/landingpage/lib/landingpage.lib.php');

		// Check if we need to display Landing page information header
		if ($parameters['module'] == 'modLandingPage') {
			$this->results['head'] = landingpageAdminPrepareHead();
			$this->results['active_tab'] = 'information';
			$this->results['langs'] = 'landingpage@landingpage';
			$this->results['header_icon'] = '';
			return 1;
		}
	}

	/**
     * Add a button in the top right menu to change the target page of the user with the actual page
     *
     * @param  array        $parameters  Hook metadatas (context, etc...)
     * @param  CommonObject $object      The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...
     * @param  string       $action      Current action (if set). Generally create or edit or null
     * @param  HookManager  $hookmanager Hook manager propagated to allow calling another hook
     * @return int                                 0 on success
     */
    public function printTopRightMenu($parameters, &$object, &$action, $hookmanager)
    {
        global $langs;

        $langs->load("landingpage@landingpage");
        $this->resprints = "<div class='classfortooltip inline-block login_block_elem inline-block' style='padding: 0px; float: left; padding: 0px; padding-right: 3px !important;' title=\"" . $langs->trans('LandingPageTitle') . "\">";
        $this->resprints .= "<a href=\"#\" id=\"landingpagebutton\"\">";
        $this->resprints .= "<span class=\"fas fa-home atoplogin valignmiddle\"></span>";
        $this->resprints .= "</a>";
        $this->resprints .= "</div>";

        $this->resprints .= '<script>
		if (document.getElementById("landingpagebutton")) {
		document.getElementById("landingpagebutton").addEventListener("click", function() {
  			$.ajax({
   				url: "' . dol_buildpath("/landingpage/ajax/update_main_landing_page.php", 1) . '",
   				type: "POST",
   				data: {
   				token: "' . newToken() . '",
       			url: "' . $_SERVER["REQUEST_URI"] . '"
  		},
   		success: function(data){
   			const json = JSON.parse(data);
   			if (json.status == 200) {
   			    Swal.fire(
   			    	"' . $langs->trans("LandingPageModified") . '",
					"",
					"success"
				)
			}
   			else {
   			    Swal.fire(
   			    	"' . $langs->trans("LandingPageNotModified") . '",
					"",
					"error"
					)
   				}
			}
		});
	});
}
</script>';
        return 0;
    }
}
